function [resid,fun_1,fun_2,xi] = fault_slip_resid_bound(a,alpha,b,ddelta_dy_cross,delta,...
    delta_c,dy_cross,D_center,eps_reg,eta_reg,flag_coupled,flag_fric,flag_merged,flag_reg,...
    g,G,kappa,K_eff,mu_dyn,mu_st,n_int,nu,p_0_center,p_inc,phi,rho_f,rho_s,sigma_v_0,theta,...
    y_a,y_bound,y_cross,y_delta)
%
% Numerically computes the residuals for use in Matlab function fsolve to compute integration
% boundaries y_bound = [y_minus y_plus] such that conditions 1 and 2 are fulfilled. 
%
% n_int = number of integration points for slip patch
% n_cross = number of integr. points for the other patch (only relevant if flag_coupled == 1)

% Compute integration points:
y_minus = y_bound(1);
y_plus = y_bound(2);
[~,~,xi,~,y_minus,y_plus] = fault_slip_compute_xi(flag_merged,n_int,y_a,y_minus,y_plus);

% Compute residuals:
y = 0; % dummy variable; not used
[fun_1,fun_2,~] = fault_slip_integrand(a,alpha,b,ddelta_dy_cross,delta,delta_c,dy_cross,...
    D_center,eps_reg,eta_reg,flag_coupled,flag_fric,flag_merged,flag_reg,g,G,kappa,K_eff,...
    mu_dyn,mu_st,nu,p_0_center,p_inc,phi,rho_f,rho_s,sigma_v_0,theta,xi,y_cross,y,y_delta,...
    y_minus,y_plus);

resid(1) = trapz(xi,fun_1);
resid(2) = trapz(xi,fun_2);
